
-- Creates the given camera class (FreeCamera, TargetCamera, PhysicalCamera) from the current view
-- Used by the macroscript associated with ctrl-c
fn CreateCameraFromView camera_class =
(
	--camera variable
	local c
	local wcol = (color 5 54 179)
	local targdist = viewport.GetFocalDistance()
	-- get viewport tm
	local viewfov = getVIewFOV()
	local cXform =  InverseHighPrecision(viewport.getTM())
	  
	--disablesceneredraw() 
	-- perspective views
	if viewport.Gettype() == #view_persp_user
	then
	(
	if (superclassof selection[1]) == camera --check if selection is a camera
		then --if selection is a camera, than call the match camera to view action
		(
			actionMan.executeAction 0 "40249" --loc_notes: do not localize this
		)
		else --if selection is not a camera, then create it for the user
		(
			-- creates a camera, and assigns the current Vport Transforms
			c = camera_class  targetDistance:targdist isSelected:on wirecolor:wcol
			-- Physical camera needs to be set to "Specify FOV"
			if(camera_class == Physical_Camera) then
			(
				c.specify_fov = true
			)
			c.fov = viewfov			
			-- Force perspective camera. Standard camera has "orthoProjection" property, but Physical camera doesn't.
			if(hasproperty c "orthoProjection") then
			(
				c.orthoProjection = false 
			)
			c.Transform = cXform 
			viewport.setcamera c
			if(Perspective_Match.IsMatching() == false) then
			(
				-- Standard camera has "type", Physical camera has "targeted"
				if(hasproperty c "type") then
					c.type = #target
				else if(hasproperty c "targeted") then
					c.targeted = true
				c.target.wirecolor = wcol
			)
			else
			(
				-- Standard camera has "type", Physical camera has "targeted"
				if(hasproperty c "type") then
					c.type = #free
				else if(hasproperty c "targeted") then
					c.targeted = false				
			)
		)--end then
	)--end then
	else
	(

	)--end else

	-- clears the local variables
	c = undefined 
	viewfov = undefined
	cXform  = undefined
	  
	--enablesceneredraw()
) 
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCmhpPGrA2RfFUi2mGEUlxOakWGdWLb/stw
-- B8kbETyD+j1EzN/7+e3fLMIFpIqPWxF3lvFr+md3JvQ6dOiV5YL5lU0t2e1kltR7
-- jh7lcEW2XVan/VkaSPPYqr+x9XFVpga5haPTwajjGGj8XNNKqgkclPabsBXrJgqN
-- S2VDcJEkcwuZRJ+ET/i1zMoZ3OVVk70+o1JtXWe7XrYLDGUV36QX9T1mSvjHJ375
-- NfFc1dY6fyOsKjTgljnNlb8/IF+JDd6mJHb2OCNi3+c/l1oKmpayPf1hvlOibHY2
-- U6OhR2u+b68gpUKlpMvm6h8yoB/x79XC4vyHyVu+/izVnAAZxqiS
-- -----END-SIGNATURE-----